IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PG_DEB_DDA_LOTE]') 	AND type in (N'U')) 
BEGIN

	SET ANSI_NULLS ON 
	SET QUOTED_IDENTIFIER ON 

	CREATE TABLE dbo.PG_DEB_DDA_LOTE
		(CD_EMP int NOT NULL,
		CD_CTR int NOT NULL IDENTITY (1, 1),
		CD_LOTE int NOT NULL,
		DT_CAD datetime NULL,
		CNPJ_CPF varchar(20) NULL,
		RZ_FORN varchar(100) NULL,
		NR_TITULO varchar(50) NULL,
		DT_EMISSAO datetime NULL,
		DT_VENCTO datetime NULL,
		VLR_ABATIMENTO money NOT NULL,
		VLR_JUROS money NOT NULL,
		VLR_TITULO money NOT NULL,
		COD_PROTESTO int NOT NULL,
		CD_BARRAS varchar(50) NOT NULL,
		VLR_CD_BARRAS money NOT NULL,
		CD_MOEDA int NOT NULL,
		DIG_VERIFICADOR int NULL,
		CAMPO_LIVRE varchar(50) NULL,
		CONCILIACAO INT NOT NULL,
		SEQUENCIA_ARQUIVO int NULL
		)  ON [PRIMARY]

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_VLR_ABATIMENTO DEFAULT 0 FOR VLR_ABATIMENTO

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_VLR_JUROS DEFAULT 0 FOR VLR_JUROS

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_VLR_TITULO DEFAULT 0 FOR VLR_TITULO

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_COD_PROTESTO DEFAULT 0 FOR COD_PROTESTO

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_CD_BARRAS DEFAULT '' FOR CD_BARRAS

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_VLR_CD_BARRAS DEFAULT 0 FOR VLR_CD_BARRAS

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_CD_MOEDA DEFAULT 0 FOR CD_MOEDA

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		DF_PG_DEB_DDA_LOTE_CONCILIACAO DEFAULT 0 FOR CONCILIACAO

	ALTER TABLE dbo.PG_DEB_DDA_LOTE ADD CONSTRAINT
		PK_PG_DEB_DDA_LOTE_1 PRIMARY KEY CLUSTERED 
		(
		CD_EMP,
		CD_CTR
		) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

END
